/* 
 * sem.c
 *
 * Обгортки для операцій із семафорами System V.
 *
 */

#include <sys/sem.h>

/* Зменшує значення семафора System V, заданого дескриптором semd і
   номером number, на 1 у блокуючому режимі. */
extern int sem_down(int semd, int number)
{
        struct sembuf sb;
        sb.sem_num = number;
        sb.sem_op = -1;
        sb.sem_flg = 0;
        return semop(semd, &sb, 1);
}

/* Зменшує значення семафора System V, заданого дескриптором semd і
   номером number, на 1 в неблокуючому режимі. */
extern int sem_trydown(int semd, int number)
{
        struct sembuf sb;
        sb.sem_num = number;
        sb.sem_op = -1;
        sb.sem_flg = IPC_NOWAIT;
        return semop(semd, &sb, 1);
}

/* Збільшує значення семафора System V, заданого дескриптором semd і
   номером number, на 1. */
extern int sem_up(int semd, int number)
{
        struct sembuf sb;
        sb.sem_num = number;
        sb.sem_op = 1;
        sb.sem_flg = 0;
        return semop(semd, &sb, 1);
}
